@extends('layouts.syndron.app')
@section('content')
<div class="row">
    <div class="col-12">
        <form action="{{ route('admin.option.store') }}" method="POST" enctype="multipart/form-data">

            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between">
                        <h3 class="header-title">
                            {{ __('create site option') }}
                        </h3>

                        <div class="">
                        </div>
                    </div>

                </div>

                <div class="card-body">
                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @csrf

                    <div class="form-group mb-3 <?= isset($_GET['group']) ? 'd-none' : 'd-block' ?>">
                        <label for="option_name">{{ __('group Name') }}</label>
                        <input type="text" class="form-control" id="group_name" name="group" value="<?= isset($_GET['group']) ? $_GET['group'] : '' ?>">
                    </div>

                    <div class="form-group mb-3">
                        <label for="option_name">{{ __('Option Name') }}</label>
                        <input type="text" class="form-control" id="option_name" name="key" required>
                    </div>
                    <div id="text-value" class="form-group mb-3">
                        <label for="option_value">{{ __('Option Value') }}</label>
                        <input type="text" class="form-control" id="option_value" name="value">
                    </div>
                    <div id="file-value" class="form-group mb-3 " style="display: none;">
                        <label for="option_value">{{ __('Option Value') }}</label>
                        <input type="file" class="form-control" id="option_value_file" name="value_file">
                    </div>

                    <div>
                        <div class="form-check mb-3">
                            <input type="checkbox" class="form-check-input" id="is_value_file" name="is_value_file" value="1" onchange="if(this.checked){document.getElementById('text-value').style.display='none';document.getElementById('file-value').style.display='block';}else{document.getElementById('text-value').style.display='block';document.getElementById('file-value').style.display='none';}">
                            <label class="form-check-label" for="is_value_file">
                                تغییر مقدار به فایل
                            </label>
                        </div>
                    </div>


                    <button type="submit" class="btn btn-primary">{{ __('Submit') }}</button>

                </div> <!-- end card-body -->
            </div> <!-- end card-->

            <div class="card">
                <div class="card-body">
                    <div class="">
                        <button type="button" id="add-link" class="btn btn-primary mt-3">افزودن دیتا</button>
                        <hr>
                        <div id="links-container">
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div> <!-- end col -->
</div>
@endsection

@section('script')
<script>
    const linksContainer = document.getElementById('links-container');
    const addLinkButton = document.getElementById('add-link');
    let linkIndex = 0;

    function addLinkGroup(key = null, value = null) {
        const linkGroup = document.createElement('div');
        linkGroup.classList.add('link-group', 'row', 'g-2');
        linkGroup.innerHTML = `
                <div class="col">
                    <input type="text" name="data[${linkIndex}][key]" class="form-control" placeholder="کلید">
                </div>
                <div class="col">
                    <input type="text" name="data[${linkIndex}][value]" class="form-control" placeholder="مقدار">
                </div>
                <div class="col">
                    <button type="button" class="btn btn-danger remove-button">حذف</button>
                </div>
            `;

        const removeButton = linkGroup.querySelector('.remove-button');
        removeButton.addEventListener('click', () => {
            linkGroup.remove();
        });

        linksContainer.appendChild(linkGroup);
        linkIndex++;
    }

    addLinkButton.addEventListener('click', addLinkGroup);

    // Add the initial link group when the page loads
</script>

@endsection
