@extends('layouts.syndron.app')
@section('content')

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between">
                    <h3 class="header-title">
                        {{ __('site options group') }}
                    </h3>

                    <div class="">
                        <a href="{{ route('admin.option.create') }}" class="btn btn-primary"> {{ __('Add new setting') }} </a>
                    </div>
                </div>

            </div>
            <div class="card-body">

                <table class="table table-striped table-bordered text-center align-middle">
                    <thead>
                        <tr>
                            <th>{{ __('#') }}</th>
                            <th>{{ __('groups') }}</th>
                            <th>{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($groups as $group)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $group->group ?? __('without group') }}</td>
                            <td>
                                <div class="dropdown">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-secondary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"> {{ __('Actions') }} <i class="mdi mdi-chevron-down"></i> </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="{{ route('admin.option.index' , ['group' => $group->group ?? '' ]) }}">{{ __('settings list') }}</a>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>

            </div> <!-- end card-body -->
        </div> <!-- end card-->
    </div> <!-- end col -->
</div>
@endsection
