@extends('layouts.syndron.app')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div>
            <h4>{{ __('Pages') }}</h4>
        </div>
        <div>
            <a class="btn btn-success" href="{{ route('admin.page.create') }}">
                {{ __('Create a new page') }}
            </a>
        </div>
    </div>
    <div class="card-body">
        <x-syndron.ui.table :columns="['title', 'slug', 'status', 'author', 'actions']">
            @foreach ($pages as $page)
            <tr>
                <td>{{ $page->title }}</td>
                <td>{{ $page->slug }}</td>
                <td>{{ ucfirst($page->status) }}</td>
                <td>{{ $page->author?->name ?? '-' }}</td>
                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button"
                            id="dropdownMenuButton{{ $page->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton{{ $page->id }}">
                            <li>
                                <a class="dropdown-item"
                                    href="{{ route('admin.page.edit', $page->id) }}">{{ __('Edit') }}
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item"
                                    href="{{ route('admin.page.show', $page->id) }}">{{ __('View') }}
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item"
                                    href="{{ route('admin.page.items.edit', $page->id) }}">{{ __('items') }}
                                </a>
                            </li>
                            @module('page-builder-grapes-js')
                            <li>
                                <a class="dropdown-item"
                                    href="{{ route('admin.pages.builder', $page->id) }}">{{ __('grapesJs') }}
                                </a>
                            </li>
                            @endmodule
                            <li>
                                <a class="dropdown-item"
                                    href="{{ route('page', $page->slug) }}">{{ __('View on website') }}
                                </a>
                            </li>
                            <li>
                                <form action="{{ route('admin.page.destroy', $page->id) }}" method="POST"
                                    onsubmit="return confirm('<?php echo __('Are you sure you want to delete this page?') ?>');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                                </form>
                            </li>
                        </ul>
                    </div>
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
