@extends('layouts.syndron.app')


@section('content')

<section>
    <div class="card">
        <div class="card-body">
            @php
            $adminColumns = ['#','creator','Customer Name','status','company name','email','phone','city','postal code','is paid' , 'actions'];
            $shopColumns = ['#','Customer Name','status','company name','email','phone','city','postal code', 'actions'];
            $columns =auth()->user()->isAdmin() ? $adminColumns : $shopColumns;
            @endphp
            <x-syndron.ui.table :columns="$columns">
                @foreach ($preInvoices as $preInvoice)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    @if (auth()->user()->isAdmin())
                    <td>{{ $preInvoice->creator?->name ?? '' }}</td>
                    @endif

                    <td>{{ $preInvoice->customer_name }}</td>
                    <td>{{ __($preInvoice->status) }}</td>
                    <td>{{ $preInvoice->company_name }}</td>
                    <td>{{ $preInvoice->email }}</td>
                    <td>{{ $preInvoice->phone }}</td>
                    <td>{{ $preInvoice->city }}</td>
                    <td>{{ $preInvoice->postal_code }}</td>
                    @if (auth()->user()->isAdmin())
                    <td>{{ $preInvoice->is_paid ? __('Paid') : __('Unpaid') }}</td>
                    @endif
                    <td>
                        <div class="dropdown">
                            <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                {{ __('Actions') }}
                            </button>
                            <ul class="dropdown-menu">
                                @can('pre-invoice.view')
                                <li>
                                    <a class="dropdown-item" href="{{ route('admin.pre-invoice.show' , $preInvoice->id) }}">
                                        {{ __('Show') }}
                                    </a>
                                </li>
                                @endcan

                                @can('pre-invoice.edit')
                                <li>
                                    <a class="dropdown-item" href="#">
                                        {{ __('Edit') }}
                                    </a>
                                </li>
                                @endcan

                                @can('pre-invoice.quote.view')
                                <li>
                                    <a class="dropdown-item" href="#">
                                        {{ __('Sellers Quotes') }}
                                    </a>
                                </li>
                                @endcan

                                @can('pre-invoice.quote.view.own')
                                <li>
                                    <a class="dropdown-item" href="#">
                                        {{ __('My Quote') }}
                                    </a>
                                </li>
                                @endcan
                            </ul>
                        </div>
                    </td>
                </tr>
                @endforeach
            </x-syndron.ui.table>
        </div>
    </div>
</section>

@endsection
