@extends('layouts.syndron.app')

@section('content')


<div class="card">
    <div class="card-body">
        <x-syndron.ui.table :columns="['#','Customer Name','status','company name','email','phone','city','postal code', 'actions']">
            @foreach ($quotes as $quote)

            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $quote->customer_name }}</td>
                <td>{{ __($quote->status) }}</td>
                <td>{{ $quote->company_name }}</td>
                <td>{{ $quote->email }}</td>
                <td>{{ $quote->phone }}</td>
                <td>{{ $quote->city }}</td>
                <td>{{ $quote->postal_code }}</td>
                <td>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu">
                            @can('pre-invoice.view')
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.pre-invoice.show' , $quote->pre_invoice_id) }}">
                                    {{ __('Show') }}
                                </a>
                            </li>
                            @endcan

                            @can('pre-invoice.edit')
                            <li>
                                <a class="dropdown-item" href="#">
                                    {{ __('Edit') }}
                                </a>
                            </li>
                            @endcan

                            @can('pre-invoice.quote.view')
                            <li>
                                <a class="dropdown-item" href="#">
                                    {{ __('Sellers Quotes') }}
                                </a>
                            </li>
                            @endcan

                            @can('pre-invoice.quote.view.own')
                            <li>
                                <a class="dropdown-item" href="#">
                                    {{ __('My Quote') }}
                                </a>
                            </li>
                            @endcan
                        </ul>
                    </div>
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>

@endsection
