@extends('layouts.syndron.app')

@section('content')
<x-syndron.breadcrumb title="{{ __('Pre invoice details') }}">
    <x-syndron.breadcrumb-item url="{{ route('admin.pre-invoice.index') }}">
        {{ __('Pre Invoices List') }}
    </x-syndron.breadcrumb-item>

    <x-syndron.breadcrumb-item active>
        {{ __(key: 'Pre invoice details') }}
    </x-syndron.breadcrumb-item>
</x-syndron.breadcrumb>

<!-- Customer Information -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="card-title mb-0">{{ __('Customer Information') }}</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <p><strong>{{ __('Customer Name') }}:</strong> {{ $preInvoice->customer_name }}</p>
                <p><strong>{{ __('Company Name') }}:</strong> {{ $preInvoice->company_name }}</p>
                <p><strong>{{ __('Email') }}:</strong> {{ $preInvoice->email }}</p>
            </div>
            <div class="col-md-6">
                <p><strong>{{ __('Phone') }}:</strong> {{ $preInvoice->phone }}</p>
                <p><strong>{{ __('Address') }}:</strong> {{ $preInvoice->address }}</p>
                <p><strong>{{ __('City') }}:</strong> {{ $preInvoice->city }} | <strong>{{ __('Postal Code') }}:</strong> {{ $preInvoice->postal_code }}</p>
            </div>
        </div>
    </div>
</div>

<!-- Items Section -->
<div class="card mb-4">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">{{ __('Products / Items') }}</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>{{ __('Product') }}</th>
                        <th>{{ __('SKU') }}</th>
                        <th>{{ __('Qty') }}</th>
                        <th>{{ __('Unit') }}</th>
                        <th>{{ __('Estimated Price') }}</th>
                        <th>{{ __('Subtotal') }}</th>
                        <th>{{ __('View Link') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($preInvoice->items as $item)
                    <tr>
                        <td>
                            <strong>{{ $item->name }}</strong>
                            @if($item->description)
                            <br><small class="text-muted">{{ $item->description }}</small>
                            @endif
                        </td>
                        <td>{{ $item->sku }}</td>
                        <td>{{ $item->qty }}</td>
                        <td>{{ $item->unit }}</td>
                        <td>{{ number_format($item->estimated_price) }}</td>
                        <td>{{ number_format($item->subtotal) }}</td>
                        <td>
                            <a href="{{ $item->external_url }}" target="_blank">
                                {{ __('visit') }}
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Quotes Section -->
@if($preInvoice->quotes->count() > 0)
<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">{{ __('Supplier Quotes') }}</h5>
    </div>
    <div class="card-body">
        @if (auth()->user()->isAdmin())
        @foreach($preInvoice->quotes as $quote)
        <div class="quote-card mb-4 border rounded p-3">
            <div class="d-flex justify-content-between align-items-start mb-3">
                <div>
                    <h6 class="mb-1">{{ __('Supplier') }}: {{ $quote->supplier->name ?? 'N/A' }}</h6>
                    <span class="badge bg-{{ $quote->status === 'accepted' ? 'success' : ($quote->status === 'pending' ? 'warning' : 'secondary') }}">
                        {{ __(ucfirst($quote->status)) }}
                    </span>
                </div>
                <div class="text-end">
                    <strong>{{ __('Total') }}: {{ $quote->currency }} {{ number_format($quote->total) }}</strong>
                    <br>
                    <small class="text-muted">{{ __('Calculated') }}: {{ $quote->currency }} {{ number_format($quote->total_calculated) }}</small>
                </div>
            </div>

            @if($quote->items->count() > 0)
            <div class="table-responsive">
                <table class="table table-sm table-bordered">
                    <thead>
                        <tr>
                            <th>{{ __('Product') }}</th>
                            <th>{{ __('Qty') }}</th>
                            <th>{{ __('Price') }}</th>
                            <th>{{ __('Delivery Time') }}</th>
                            <th>{{ __('Subtotal') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($quote->items as $quoteItem)
                        <tr>
                            <td>{{ $quoteItem->preInvoiceItem->name ?? 'N/A' }}</td>
                            <td>{{ $quoteItem->qty }}</td>
                            <td>{{ $quote->currency }} {{ number_format($quoteItem->price) }}</td>
                            <td>{{ $quoteItem->delivery_time ?? 'N/A' }}</td>
                            <td>{{ $quote->currency }} {{ number_format($quoteItem->subtotal) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @endif

            @if($quote->terms || $quote->notes)
            <div class="row mt-3">
                @if($quote->terms)
                <div class="col-md-6">
                    <strong>{{ __('Terms') }}:</strong>
                    <p class="mb-0">{{ $quote->terms }}</p>
                </div>
                @endif
                @if($quote->notes)
                <div class="col-md-6">
                    <strong>{{ __('Notes') }}:</strong>
                    <p class="mb-0">{{ $quote->notes }}</p>
                </div>
                @endif
            </div>
            @endif
        </div>
        @endforeach
        @else
        @php
        $quote = $preInvoice->quotes->where('supplier_id', auth()->user()->shop->id)->first();
        @endphp
        @if ($quote != null)
        <div class="quote-card mb-4 border rounded p-3">
            <div class="d-flex justify-content-between align-items-start mb-3">
                <div>
                    <h6 class="mb-1">{{ __('Supplier') }}: {{ $quote->supplier->name ?? 'N/A' }}</h6>
                    <span class="badge bg-{{ $quote->status === 'accepted' ? 'success' : ($quote->status === 'pending' ? 'warning' : 'secondary') }}">
                        {{ __(ucfirst($quote->status)) }}
                    </span>
                </div>
                <div class="text-end">
                    <strong>{{ __('Total') }}: {{ $quote->currency }} {{ number_format($quote->total) }}</strong>
                    <br>
                    <small class="text-muted">{{ __('Calculated') }}: {{ $quote->currency }} {{ number_format($quote->total_calculated) }}</small>
                </div>
            </div>

            @if($quote->items->count() > 0)
            <div class="table-responsive">
                <table class="table table-sm table-bordered">
                    <thead>
                        <tr>
                            <th>{{ __('Product') }}</th>
                            <th>{{ __('Qty') }}</th>
                            <th>{{ __('Price') }}</th>
                            <th>{{ __('Delivery Time') }}</th>
                            <th>{{ __('Subtotal') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($quote->items as $quoteItem)
                        <tr>
                            <td>{{ $quoteItem->preInvoiceItem->name ?? 'N/A' }}</td>
                            <td>{{ $quoteItem->qty }}</td>
                            <td>{{ $quote->currency }} {{ number_format($quoteItem->price) }}</td>
                            <td>{{ $quoteItem->delivery_time ?? 'N/A' }}</td>
                            <td>{{ $quote->currency }} {{ number_format($quoteItem->subtotal) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @endif

            @if($quote->terms || $quote->notes)
            <div class="row mt-3">
                @if($quote->terms)
                <div class="col-md-6">
                    <strong>{{ __('Terms') }}:</strong>
                    <p class="mb-0">{{ $quote->terms }}</p>
                </div>
                @endif
                @if($quote->notes)
                <div class="col-md-6">
                    <strong>{{ __('Notes') }}:</strong>
                    <p class="mb-0">{{ $quote->notes }}</p>
                </div>
                @endif
            </div>
            @endif
        </div>
        @else
        <div class="alert alert-info d-flex justify-content-between">
            {{ __('you did not submit any quote') }}

            <a class="btn btn-sm btn-primary" href="{{ route('admin.pre-invoice.quote.create' , $preInvoice->id) }}">
                {{ __('submit a new quote') }}
            </a>
        </div>
        @endif
        @endif

    </div>
</div>
@else
<div class="alert alert-info d-flex justify-content-between">
    {{ __('No quotes available for this pre-invoice.') }}

    <a class="btn btn-sm btn-primary" href="{{ route('admin.pre-invoice.quote.create' , $preInvoice->id) }}">
        {{ __('submit a new quote') }}
    </a>
</div>
@endif

<!-- Notes Section -->
@if($preInvoice->notes)
<div class="card mt-4">
    <div class="card-header">
        <h5 class="card-title mb-0">{{ __('Additional Notes') }}</h5>
    </div>
    <div class="card-body">
        <p class="mb-0">{{ $preInvoice->notes }}</p>
    </div>
</div>
@endif

@endsection
