@extends('layouts.syndron.app')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between">
        <h1>{{ __('Office Equipment Groups') }}</h1>
        <a href="{{ route('admin.product-bundle.create') }}" class="btn btn-primary mb-3">{{ __('Create New Group') }}</a>
    </div>
    <div class="card-body">
        <div class="">

            <table class="table table-striped table-bordered rounded align-middle text-center">
                <thead>
                    <tr>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Description') }}</th>
                        <th>{{ __('Created By') }}</th>
                        <th>{{ __('Actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($groups as $group)
                    <tr>
                        <td>{{ $group->name }}</td>
                        <td>{{ $group->description }}</td>
                        <td>{{ $group->creator->name ?? 'N/A' }}</td>
                        <td>
                            @can('office-equipment-group.view')
                            <a href="{{ route('admin.product-bundle.show', $group) }}" class="btn btn-info btn-sm">{{ __('View') }}</a>
                            @endcan
                            @can('office-equipment-group.edit')
                            <a href="{{ route('admin.product-bundle.edit', $group) }}" class="btn btn-warning btn-sm">{{ __('Edit') }}</a>
                            @endcan

                            @can('office-equipment-group.delete')
                            <form action="{{ route('admin.product-bundle.destroy', $group) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm">{{ __('Delete') }}</button>
                            </form>
                            @endcan
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
