@extends('layouts.syndron.app')

@section('style')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
@endsection

@section('content')

@if (Route::is('admin.shop.product-selection'))
<div class="card shadow-sm border-0" style="height: 220px;">
    <div class="card-body d-flex justify-content-between align-items-center">
        <div>
            <h5 class="card-title mb-3">
                محصول مورد نظرتون رو پیدا نکردید؟
            </h5>
            <p class="card-text text-muted mb-4">
                نگران نباشید! می‌تونید محصول جدید خودتون رو همین حالا ثبت کنید تا به فروشگاه اضافه بشه.
            </p>
            <div class="d-flex align-items-center gap-2">
                <form class="d-flex align-items-center gap-2 " action="{{ route('admin.product.create') }}" method="get">
                    <div class="mb-4">
                        <label for="single-select-field" class="form-label">دسته بندی ها</label>
                        <select class="form-select" id="single-select-field" name="category_id" data-placeholder="انتخاب دسته بندی" required>
                            <option></option>
                            @foreach (\App\Models\Category::with('parent')->withoutChildren()->get()->groupBy('parent_id') as $parent => $children)
                                <optgroup label="{{ $children->first()->parent->name }}">
                                    @foreach ($children as $category)
                                        <option value="{{ $category->id }}">{{ $category->name }}</option>
                                    @endforeach
                                </optgroup>
                            @endforeach
                        </select>
                    </div>
                    <button type="submit" href="#" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-1"></i> ایجاد محصول جدید
                    </button>
                </form>
                <a href="#" class="btn btn-outline-secondary">
                    <i class="bi bi-question-circle me-1"></i> راهنما
                </a>
            </div>
        </div>
        <div>
            <img src="/assets/images/product-photography.svg" style="height: 180px;" alt="ایجاد محصول">
        </div>
    </div>
</div>


@endif


<div class="mb-3 position-relative pt-5" x-data="{showFilter: false}">
    <div x-show="showFilter">
        <x-syndron.form.product-filter-form />
    </div>

    <button class="position-absolute top-0 end-0 mt-2 me-2 btn btn-primary btn-sm" @click="showFilter = !showFilter">
        <i class="bx bx-filter"></i>
        {{ __('Filter') }}
    </button>
</div>


@if (!Route::is('admin.shop.product-selection'))
<div class="d-flex gap-2 mb-2 pb-3 border-bottom">
    <a class="btn btn-primary btn-sm" href="{{ route('admin.product.index' , ['show' => 'list']) }}">نمایش به صورت لیست</a>
    <a class="btn btn-primary btn-sm" href="{{ route('admin.product.index' , ['show' => 'grid']) }}">نمایش به صورت گرید</a>
</div>
@endif



@if (!isset($_GET['show']) || $_GET['show'] === 'list')
<div>
    <x-syndron.ui.table :columns="['Image', 'Title', 'Category' ,'Code', 'Price','Price With Discount','Off Rate', 'Status', 'Actions']">
        @forelse ($products as $product)
        <tr>
            <td><img src="{{ $product->brand_img }}" class="img-thumbnail square-box" style="height: 80px;" alt="{{ $product->title }}"></td>
            <td>{{ $product->title }}</td>
            <td>{{ $product->category->name }}</td>
            <td>{{ $product->code }}</td>
            <td>{{ number_format($product->price) }}</td>
            <td>{{ number_format($product->discount_price) }}</td>
            <td>%{{ $product->off_rate }}</td>
            <td>
                {{ __($product->status) }}
            </td>
            <td>
                <div class="d-flex flex-wrap justify-content-center align-items-center gap-1">
                    @can('product.add.inventory')
                    <div class="w-100">
                        @if(array_search($product->id, array_values($shopInventories)) === false)
                        <a class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#productModal-{{$product->id}}">{{ __('i want to sell this product too') }}</a>
                        @else
                        <p class="text-info">{{ __('you already add this product') }}</p>
                        <a href="{{ route('admin.shop.inventory.index') }}" class="btn btn-primary btn-sm">{{ __('see my inventory') }}</a>
                        @endif
                    </div>
                    @endcan
                    @can('product.show')
                    <a class="btn btn-primary btn-sm" href="{{ route('admin.product.show', $product->id) }}">{{ __('Show') }}</a>
                    @endcan
                    @can( 'product.edit')
                    <a class="btn btn-warning btn-sm" href="{{ route('admin.product.edit', $product->id) }}">{{ __('Edit') }}</a>
                    @endcan
                    @can('product.delete')
                    <form action="{{ route('admin.product.destroy', $product->id) }}" method="POST" onsubmit="return confirm('<?php echo  __('Are you sure you want to delete this product?'); ?>');">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-danger btn-sm" type="submit">{{ __('Delete') }}</button>
                    </form>
                    @endcan
                </div>
            </td>
        </tr>
        @empty
        <tr>
            <td colspan="8" class="text-center">{{ __('No products found.') }}</td>
        </tr>
        @endforelse
    </x-syndron.ui.table>
</div>
@endif
@if (isset($_GET['show']) && $_GET['show'] == 'grid')
<div class="row row-cols-1 row-cols-sm-2 row-cols-lg-3 row-cols-xl-4 row-cols-xxl-5 product-grid">
    @forelse ($products as $product )
    <div class="col">
        <x-syndron.ui.product-card :product="$product" />
    </div>
    @empty
    @endforelse
</div>
@endif



@forelse ($products as $product)
<div class="modal fade" id="productModal-{{ $product->id }}" tabindex="-1" aria-labelledby="productModal-{{ $product->id }}-Label" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable  modal-dialog-centered">
        <div class="modal-content">

            <div class="modal-body">
                <x-syndron.elements.product-details :product="$product" />
                <hr>
                <form class="use-ajax" action="{{ route('admin.shop.inventory.store') }}" method="post">
                    @csrf
                    <input type="text" name="product_id" value="{{ $product->id }}" hidden>
                    <div class="mb-3">
                        <x-syndron.ui.form.number-input />
                        @error('quantity')
                        <small class="text-danger"> {{ $message }} </small>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="price">{{ __('Price') }}</label>
                        <input type="text" name="price" class="form-control" id="price" value="{{ $product->price }}" placeholder="{{ __('Price') }}">
                        @error('price')
                        <small class="text-danger"> {{ $message }} </small>
                        @enderror
                    </div>
                    <div class="d-flex justify-content-end">
                        <button class="btn btn-primary" type="submit">
                            {{ __('Add to my inventory') }}
                        </button>

                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
            </div>
        </div>
    </div>
</div>
@empty
@endforelse


{{ $products->links() }}
@endsection


@section('script')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="/assets/themes/syndron/plugins/select2/js/select2-custom.js"></script>
@endsection
