@extends('layouts.syndron.app')

@section('content')

<x-syndron.cache-manager />

<div class="container">
    <h2 class="mb-4">{{ __('Cache Manager') }}</h2>

    @if (session('status'))
    <div class="alert alert-success">{{ session('status') }}</div>
    @endif

    <form method="POST" action="{{ route('admin.settings.cache.refresh') }}" class="mb-3 d-flex align-items-center gap-3">
        @csrf
        <label for="cacheable">{{ __('Select Cache Class') }}:</label>
        <select name="cacheable" id="cacheable" class="form-select w-auto">
            @foreach($cacheables as $label => $class)
            <option value="{{ $label }}">{{ $label }}</option>
            @endforeach
        </select>

        @can('settings.cache.refresh')
        <button formaction="{{ route('admin.settings.cache.refresh') }}" class="btn btn-primary">🔄 {{ __('Refresh') }}</button>
        @endcan
        @can('settings.cache.clear')
        <button formaction="{{ route('admin.settings.cache.clear') }}" class="btn btn-warning">🧹 {{ __('Clear') }}</button>
        @endcan
        @can('settings.cache.value')
        <button formaction="{{ route('admin.settings.cache.value') }}" class="btn btn-info">👁️ {{ __('View') }}</button>
        @endcan
    </form>

    @if(session('value'))
    <div class="card mt-4">
        <div class="card-header">Cached Value</div>
        <div class="card-body">
            <pre>{{ print_r(session('value'), true) }}</pre>
        </div>
    </div>
    @endif
</div>
@endsection
