@extends('layouts.syndron.app')

@section('content')

@session('error')
<div class="alert alert-danger">
    {{ session('error') }}
</div>
@endsession
@session('success')
<div class="alert alert-success">
    {{ session('success') }}
</div>
@endsession

<form action="{{ route('admin.settings.data.import.file') }}" method="POST" enctype="multipart/form-data" class="border p-4 rounded shadow-sm bg-white">
    @csrf

    <div class="mb-3">
        <label for="importType" class="form-label">
            {{__('select import type')}}
        </label>
        <select class="form-select" id="importType" name="type" required>
            <option value="">{{ __('chose') }}</option>
            <option value="category">{{ __('categories') }}</option>
            <option value="product">{{ __('products') }}</option>
        </select>
        <div class="form-text">
            {{__('choose the type of data you want to import')}}
        </div>
    </div>
    <div class="mb-3">
        <label for="excelFile" class="form-label">
            {{__('upload excel file')}}
        </label>
        <input type="file" class="form-control" id="excelFile" name="file" accept=".xlsx,.xls,.csv" required>
        <div class="form-text">
            {{__('only excel files are supported')}}
        </div>
    </div>

    <button type="submit" class="btn btn-primary">
        {{ __('import categories') }}
    </button>
</form>

@endsection
