@extends('layouts.syndron.app')

@section('title')
{{ __('assign permission to user') }}
@endsection

@section('author', '')
@section('keywords', '')
@section('description', '')

@section('style')

@endsection

@section('content')


@inject('verta', 'Hekmatinasser\Verta\Verta')
@inject('Carbon', 'Carbon\Carbon')
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3"> Edit user permission </div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item active" aria-current="page">
                    <a href="{{ route('admin.settings.users.show' , $user->id) }}"> {{ __('user profile') }}</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                    {{ __('edit user permission') }}
                </li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto" dir="ltr">
        <div class="btn-group ">
            <button type="button" class="btn btn-primary split-bg-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown"> <span class="">{{ __('Settings') }}</span>
            </button>
            <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end"> <a class="dropdown-item" href="javascript:;">Action</a>
                <a class="dropdown-item" href="javascript:;">Another action</a>
                <a class="dropdown-item" href="javascript:;">Something else here</a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item" href="javascript:;">Separated link</a>
            </div>
        </div>
    </div>
</div>
<!-- Permission_status -->

@if (session('error'))
<x-syndron.ui.alert type="success" title="{{ __('The operation encountered an error ') }}" icon="bx bxs-check-circle">
    <div>{{session('error')}}</div>
</x-syndron.ui.alert>
@endif
@if (session('status_fail'))
<x-syndron.ui.alert type="success" title="{{ __('The operation encountered an error ') }}" icon="bx bxs-check-circle">
    <div>{{session('status_fail')}}</div>
</x-syndron.ui.alert>
@endif
@if (session('status_success'))
<x-syndron.ui.alert type="success" title="{{ __('The operation was successful') }}" icon="bx bxs-check-circle">
    <div>{{session('status_success')}}</div>
</x-syndron.ui.alert>
@endif



<!-- Permission_status -->
<div class="">
    <div class="">
        <div class="card radius-5">
            <div class="card-body">

                <form action="" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-sm-12">
                            <p>
                                {{ __('user name') }}:
                                {{ $user->name }}
                            </p>
                        </div>
                    </div>
                    <p>
                        {{ __('user role') }}:
                        @foreach($user_roles as $user_role)
                        <span class="badge bg-secondary rounded-pill">{{ $user_role }}</span>
                        @endforeach
                    </p>



                </form>
            </div>
        </div>
    </div>
    <p class="ps-2">
        {{ __('System role') }}
    </p>
    <div class="">
        <div class="card">
            <div class="card-body radius-5 ">
                <div class="form-check col-sm-4">
                    <input class="form-check-input cursor-pointer roles" type="checkbox" name="selectAll" id="selectAll">
                    <label class="form-check-label cursor-pointer" for="selectAll">{{ __('select all') }}</label>
                </div>
                <hr>
                <form action="{{ route('admin.settings.user.role.assign',['id'=>$user->id] );}}" method="POST">
                    @csrf
                    <div class="row px-5">
                        @foreach($roles as $id => $role)
                        <div class="form-check col-sm-4">
                            <input class="form-check-input cursor-pointer roles" type="checkbox" name="roles[]" value="{{$role}}" id="{{'role_'.$id}}" @if($user_roles->search($role) !== false ) {{'checked'}} @endif>
                            <label class="form-check-label cursor-pointer" for="{{'role_'.$id}}">{{$role}}</label>
                        </div>
                        @endforeach
                    </div>

                    <div class="px-4 mt-3 d-flex justify-content-end">
                        <input type="submit" value="{{ __('assign roles') }}" class="btn btn-primary px-5">
                    </div>
                </form>
            </div>
        </div>
    </div>


</div>
@endsection

@section("script")
<script>
    $(document).ready(function() {
        $("#selectAll").change(function() {
            $(".roles").prop('checked', this.checked);
        });
    });
</script>
@endsection
