@extends('layouts.syndron.app')

@section('content')
<div class="card radius-10 w-100">
    <div class="card-header d-flex justify-content-between">
        <h5 class="mb-0">{{ __('User') }}</h5>
        <div class="card-tools">
            <a href="{{ route('admin.settings.users.create') }}" class="btn btn-success btn-sm">
                <i class="bx bx-user-plus"></i>
                {{ __('create a new user') }}
            </a>
        </div>
    </div>
    <div class="customers-list p-3 mb-3 ps ps--active-y">
        @forelse ( $users as $user )
        <x-syndron.elements.user-list-item :user="$user" />
        @empty

        @endforelse
    </div>
</div>
@endsection

@section('script')
<script>
    new PerfectScrollbar('.customers-list');
</script>
@endsection
