@extends('layouts.syndron.app') {{-- Or your admin layout --}}

@section('title', 'Edit Shop Profile')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">{{ __('Edit Shop Profile') }}: {{ $shop->name }}</h1>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">{{ __('Shop Details') }}</h6>
        </div>
        <div class="card-body">
            <x-syndron.form.shop-form
                :shop="$shop"
                method="PUT"
                action="{{ route('admin.shops.update', $shop) }}"
            />
        </div>
    </div>
</div>
@endsection
