@extends('layouts.syndron.app')

@section('content')

<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div>
            <h4>
                {{ __('Tags') }}
            </h4>
        </div>
        <div>
            <a class="btn btn-success" href="{{ route('admin.tags.create') }}">
                {{ __('Create a new tag') }}
            </a>
        </div>
    </div>

    <div class="card-body">
        <x-syndron.ui.table :columns="['name' , 'slug' , 'color','description', 'actions']">
            @foreach ($tags as $tag )
            <tr>
                <td>{{ $tag->name  }}</td>
                <td>{{ $tag->slug  }}</td>
                <td>{{ $tag->color  }}</td>
                <td>{{ $tag->description  }}</td>
                <td>
                    @can('tag.edit')
                    <a href="{{ route('admin.tags.edit', $tag->id) }}" class="btn btn-sm btn-primary">{{ __('Edit') }}</a>
                    @endcan

                    @can('tag.delete')
                    <form action="{{ route('admin.tags.destroy', $tag->id) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger">{{ __('Delete') }}</button>
                    </form>
                    @endcan
                </td>

            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
