@extends('pages.admin.woo-commerce.woo-app')

@section('woo-content')
<div>
    <table id="" class="table dataTable woo-data-table text-start align-middle">
        <thead>
            <tr>
                <th>#</th>
                <th>{{ __('avatar') }}</th>
                <th>{{ __('email') }}</th>
                <th>{{ __('first name') }}</th>
                <th>{{ __('last name') }}</th>
                <th>{{ __('username') }}</th>
                <th>{{ __('date created') }}</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($customers as $customer)
            <tr>
                <td class="text-start">
                    {{ $loop->iteration }}
                </td>
                <td>
                    <img src="{{ $customer->avatarUrl }}" alt="{{ $customer->firstName }} {{ $customer->lastName }}" class="table-image">
                </td>
                <td>
                    {{ $customer->email }}
                </td>
                <td>
                    {{ $customer->firstName }}
                </td>
                <td>
                    {{ $customer->lastName }}
                </td>
                <td>
                    {{ $customer->username }}
                </td>
                <td>
                    {{ verta($customer->dateCreated)?->format(getDateFormat()) }}
                </td>
                <td>

                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
