@extends('layouts.syndron.app')


@section('content')
<div class="container py-4" dir="rtl">
    <!-- Hero -->
    <div class="row align-items-center g-4 mb-4">
        <div class="col-lg-7">
            <h1 class="fw-bold mb-3 text-primary">اتصال فروشگاه ووکامرس به وب‌سایت شما</h1>
            <p class="lead text-muted mb-3">
                در این راهنما یاد می‌گیرید چطور فروشگاه ووکامرس خود را به سیستم ما متصل کنید تا
                محصولات، سفارش‌ها و موجودی‌ها به‌صورت خودکار همگام‌سازی شوند.
            </p>
            <div class="d-flex gap-2">
                <a href="#how-to-connect" class="btn btn-primary">شروع اتصال</a>
                <a href="#benefits" class="btn btn-outline-primary">مزیت‌ها</a>
                <a href="#faq" class="btn btn-outline-secondary">سوالات متداول</a>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <h5 class="mb-2">پیش‌نیازها</h5>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item">وُردپرس + WooCommerce (نسخه ۳ به بالا)</li>
                        <li class="list-group-item">دسترسی ادمین به پیشخوان وردپرس</li>
                        <li class="list-group-item">فعال بودن پیوندهای یکتا (Permalinks)</li>
                        <li class="list-group-item">ایجاد کلیدهای REST API (Read/Write)</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Benefits -->
    <div id="benefits" class="mb-5">
        <h2 class="h4 fw-bold mb-3">چرا اتصال ووکامرس به سیستم ما؟</h2>
        <div class="row g-3">
            <div class="col-md-6 col-xl-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">همگام‌سازی خودکار</h5>
                        <p class="card-text text-muted">محصولات، قیمت‌ها و موجودی‌ها به‌صورت زمان‌بندی‌شده یا آنی هماهنگ می‌شوند.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xl-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">مدیریت سفارش یکپارچه</h5>
                        <p class="card-text text-muted">سفارش‌های ثبت‌شده در ووکامرس داخل پنل شما قابل مشاهده و پیگیری‌اند.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xl-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">گزارش‌دهی بهتر</h5>
                        <p class="card-text text-muted">گزارش فروش، محصولات پرفروش، و عملکرد کمپین‌ها را یکجا ببینید.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xl-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">چند فروشگاه</h5>
                        <p class="card-text text-muted">امکان اتصال چند فروشگاه ووکامرس و مدیریت همه در یک پنل.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xl-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">کاهش دوباره‌کاری</h5>
                        <p class="card-text text-muted">نیازی به واردکردن دستی اطلاعات در چند سیستم نیست.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xl-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">ایمن و قابل‌اعتماد</h5>
                        <p class="card-text text-muted">اتصال از طریق REST API و کلیدهای اختصاصی انجام می‌شود.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- How to connect -->
    <div id="how-to-connect" class="mb-5">
        <h2 class="h4 fw-bold mb-3">مراحل اتصال ووکامرس</h2>

        <div class="alert alert-info">
            <strong>نکته:</strong> قبل از شروع، در وردپرس مسیر <code>تنظیمات &rarr; پیوندهای یکتا</code> را باز کنید و نوع پیوند یکتا را روی گزینه‌ای غیر از «ساده» بگذارید.
        </div>

        <ol class="list-group list-group-numbered">
            <li class="list-group-item">
                در پیشخوان وردپرس به <strong>WooCommerce &rarr; Settings &rarr; Advanced &rarr; REST API</strong> بروید و روی <em>Add key</em> کلیک کنید.
                <div class="small text-muted mt-2">یک نام دلخواه وارد کنید، کاربر ادمین انتخاب شود، و دسترسی را روی <strong>Read/Write</strong> قرار دهید.</div>
            </li>
            <li class="list-group-item">
                پس از ساخت، دو مقدار <code>Consumer key</code> و <code>Consumer secret</code> را کپی کنید و در جایی امن نگه دارید.
            </li>
            <li class="list-group-item">
                به پنل وب‌سایت ما بیایید و از مسیر
                <span class="badge bg-primary">فروشگاه‌ها &rarr; افزودن ووکامرس</span>
                اطلاعات زیر را ثبت کنید:
                <ul class="mt-2">
                    <li>آدرس سایت ووکامرس (مثال: <code>https://example.com</code>)</li>
                    <li>Consumer Key</li>
                    <li>Consumer Secret</li>
                    <li class="text-muted">(اختیاری) Webhook Secret برای رویدادهای لحظه‌ای</li>
                </ul>
            </li>
            <li class="list-group-item">
                دکمه <strong>اتصال</strong> را بزنید. اگر همه‌چیز درست باشد، وضعیت اتصال سبز می‌شود و می‌توانید همگام‌سازی را آغاز کنید.
            </li>
        </ol>

        <div class="card mt-4 border-0 shadow-sm">
            <div class="card-body">
                <h5 class="card-title">تنظیمات پیشنهادی همگام‌سازی</h5>
                <div class="row g-3">
                    <div class="col-md-4">
                        <div class="p-3 bg-light rounded-3 h-100">
                            <strong>محصولات</strong>
                            <p class="mb-0 small text-muted">عنوان، قیمت، تصاویر، موجودی، وضعیت انتشار</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="p-3 bg-light rounded-3 h-100">
                            <strong>سفارش‌ها</strong>
                            <p class="mb-0 small text-muted">وضعیت پرداخت/ارسال، اقلام سفارش، مشتری</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="p-3 bg-light rounded-3 h-100">
                            <strong>موجودی</strong>
                            <p class="mb-0 small text-muted">کاهش موجودی پس از فروش، اخطار اتمام موجودی</p>
                        </div>
                    </div>
                </div>
                <div class="mt-3">
                    <a href="{{ route('admin.shop.woocommerce.register') }}" class="btn btn-success">شروع همگام‌سازی</a>
                    <a href="#faq" class="btn btn-outline-secondary">حل مشکلات اتصال</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Troubleshooting -->
    <div class="mb-5">
        <h2 class="h4 fw-bold mb-3">عیب‌یابی سریع</h2>
        <div class="row g-3">
            <div class="col-md-6">
                <div class="border rounded-3 p-3 h-100">
                    <h6 class="mb-2">خطای 401: <code>woocommerce_rest_cannot_view</code></h6>
                    <ul class="small mb-0 text-muted">
                        <li>بررسی کنید کلیدها درست و دارای دسترسی <strong>Read/Write</strong> باشند.</li>
                        <li>از فعال بودن پیوند یکتا اطمینان حاصل کنید.</li>
                        <li>اگر افزونه امنیتی دارید، دسترسی به مسیر <code>/wp-json</code> را مسدود نکرده باشد.</li>
                        <li>تفاوت <code>http</code> و <code>https</code> در آدرس سایت را دقیق وارد کنید.</li>
                    </ul>
                </div>
            </div>
            <div class="col-md-6">
                <div class="border rounded-3 p-3 h-100">
                    <h6 class="mb-2">عدم بارگذاری محصولات/تصاویر</h6>
                    <ul class="small mb-0 text-muted">
                        <li>حجم تصاویر و محدودیت‌های هاست را بررسی کنید.</li>
                        <li>وضعیت انتشار محصول در ووکامرس «منتشر شده» باشد.</li>
                        <li>زمان‌بندی کرون‌جاب/کیو را در هاست فعال کنید.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- FAQ -->
    <div id="faq" class="mb-5">
        <h2 class="h4 fw-bold mb-3">سوالات متداول</h2>
        <div class="accordion" id="faqAcc">
            <div class="accordion-item">
                <h2 class="accordion-header" id="q1">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#a1">
                        آیا می‌توان چند فروشگاه را همزمان متصل کرد؟
                    </button>
                </h2>
                <div id="a1" class="accordion-collapse collapse" data-bs-parent="#faqAcc">
                    <div class="accordion-body">
                        بله، هر فروشگاه با کلیدهای مخصوص خود ثبت می‌شود و مدیریت آنها به‌صورت مجزا امکان‌پذیر است.
                    </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="q2">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#a2">
                        همگام‌سازی دستی است یا خودکار؟
                    </button>
                </h2>
                <div id="a2" class="accordion-collapse collapse" data-bs-parent="#faqAcc">
                    <div class="accordion-body">
                        هر دو. می‌توانید همگام‌سازی زمان‌بندی‌شده داشته باشید و در صورت نیاز همگام‌سازی فوری انجام دهید.
                    </div>
                </div>
            </div>
            <div class="accordion-item">
                <h2 class="accordion-header" id="q3">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#a3">
                        اطلاعات حساس مثل کلیدها چگونه نگهداری می‌شوند؟
                    </button>
                </h2>
                <div id="a3" class="accordion-collapse collapse" data-bs-parent="#faqAcc">
                    <div class="accordion-body">
                        کلیدها در پایگاه داده به‌صورت امن (ترجیحاً رمزنگاری‌شده) ذخیره و فقط برای درخواست‌های API استفاده می‌شوند.
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- CTA -->
    <div class="bg-light rounded-3 p-4 d-flex flex-column flex-md-row align-items-center justify-content-between">
        <div class="mb-3 mb-md-0">
            <h5 class="mb-1">آماده‌اید فروشگاه‌تان را متصل کنید؟</h5>
            <p class="text-muted mb-0 small">با چند کلیک ساده اتصال برقرار می‌شود و همگام‌سازی آغاز خواهد شد.</p>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.shop.woocommerce.register') }}" class="btn btn-primary">افزودن فروشگاه ووکامرس</a>
            <!-- <a href="" class="btn btn-outline-secondary">مستندات فنی</a> -->
        </div>
    </div>
</div>
@endsection
