@extends('layouts.blesser.app')


@section('content')

<div class="container pb-28 pt-6 lg:pb-10">
    <!--  Breadcrumb -->
    <div class="mb-2 rounded-lg bg-muted shadow lg:mb-6">
        <ol class="relative grid grid-cols-3 overflow-hidden rounded-lg">
            <li class="z-10 flex flex-col items-center justify-center gap-2 p-4 text-xs text-primary sm:text-sm md:text-base">
                <div class="i-lucide-shopping-cart h-6 w-6 md:h-8 md:w-8"></div>
                <p class="leading-none">{{ __('cart') }}</p>
            </li>
            <li class="z-10 flex flex-col items-center justify-center gap-2 p-4 text-xs text-primary/50 sm:text-sm md:text-base">
                <div class="i-lucide-clipboard-pen-line h-6 w-6 md:h-8 md:w-8"></div>

                <p class="leading-none">{{ __('delivery') }}</p>
            </li>
            <li class="z-10 flex flex-col items-center justify-center gap-2 p-4 text-xs text-primary/50 sm:text-sm md:text-base">
                <div class="i-lucide-credit-card h-6 w-6 md:h-8 md:w-8"></div>

                <p class="leading-none">{{ __('payment') }}</p>
            </li>
            <!--  for position set value 0 , 33.33% , 66.66%  -->
            <div class="absolute bottom-0 z-0 h-full w-1/3 touch-none bg-primary/10 transition-all duration-300" style="inset-inline-start: 0"></div>
        </ol>
    </div>
    <!-- Content -->
    <div class="grid grid-cols-12 gap-2 lg:gap-6">
        <div class="col-span-12 lg:col-span-8">
            <div class="rounded-lg bg-muted shadow">
                <div class="flex items-center justify-between gap-2 p-4">
                    <h1 class="flex items-center gap-x-4 text-sm xs:text-base md:text-lg">
                        {{ __('shopping cart') }}
                        <span class="text-sm text-text/60"> ( {{ $cart !== null ? $cart->count() : 0 }} {{ __("items") }} ) </span>
                    </h1>
                    <form action="{{ route('cart.clear') }}" method="POST">
                        @csrf
                        <button class="inline-flex h-9 items-center justify-center gap-x-2 whitespace-nowrap rounded-md px-3 text-sm font-medium text-warning ring-offset-background transition-colors hover:text-warning/70 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50" type="submit">
                            <div class="i-lucide-trash-2 h-5 w-5"></div>
                            <span>
                                {{ __('clear cart') }}
                            </span>
                        </button>
                    </form>
                </div>
                @if($items == null)
                <div class="flex items-center justify-center py-10">
                    <div class="flex flex-col items-center justify-center gap-4">
                        <div class="i-lucide-package-x w-12 h-12"></div>
                        <div>
                            {{ __('your cart is empty') }}
                        </div>
                    </div>
                </div>
                @else
                <ul class="divide-y">
                    @foreach($items as $item)
                    <li>
                        <div class="px-4 py-4 sm:py-6">
                            <div class="grid grid-cols-2 items-center justify-start gap-2 xs:grid-cols-3 xs:gap-6 sm:grid-cols-4 xl:grid-cols-6">
                                <div class="relative row-span-2 min-w-fit xs:mx-auto">
                                    <a href="{{ route('product.details', $item->product->slug) }}">
                                        <img src="{{ $item->product->brand_img }}" alt="{{ $item->product->title }}" class="h-25 w-25 rounded-lg object-cover sm:h-28 sm:w-28">
                                    </a>
                                    <form action="{{ route('cart.remove') }}" method="POST" class="absolute -top-2 right-0">
                                        @csrf
                                        <input type="hidden" name="product_id" value="{{ $item->product->id }}">
                                        <input type="hidden" name="inventory_id" value="{{ $item->inventory_id }}">
                                        <input type="hidden" name="variant" value="{{ $item->variant_id }}">
                                        <input type="hidden" name="shop_id" value="{{ $item->shop_id }}">
                                        <button type="submit" class="rounded-lg border bg-muted duration-200 hover:bg-background p-2">
                                            <div class="i-lucide-trash m-0 h-5 w-5 text-warning"></div>
                                        </button>
                                    </form>
                                </div>
                                <div class="row-span-2 space-y-4 xs:col-span-2 sm:col-span-3 xl:col-span-5">
                                    <a href="{{ route('product.details', $item->product->slug) }}" class="line-clamp-2 text-sm xs:text-base">{{ $item->product->title }}</a>
                                    <div class="space-y-2 text-text/95">
                                        @if(!empty($item->variant))
                                        @foreach(json_decode($item->variant) as $key => $value)
                                        <div class="flex items-center gap-2">
                                            <div>{{ ucfirst($key) }}</div>
                                            <div>
                                                @if(is_string($value) && Str::startsWith($value, '#'))
                                                <div class="h-6 w-6 rounded-full border-2" style="background-color: <?php echo $value ?>"></div>
                                                @else
                                                <div>{{ $value }}</div>
                                                @endif
                                            </div>
                                        </div>
                                        @endforeach
                                        @endif

                                    </div>
                                </div>
                                <div class="flex items-center gap-x-2 xs:justify-center">
                                    <form action="{{ route('cart.update') }}" method="POST" class="flex items-center">
                                        @csrf
                                        <input type="hidden" name="product_id" value="{{ $item->product->id }}">
                                        <input type="hidden" name="inventory_id" value="{{ $item->inventory_id }}">
                                        <input type="hidden" name="shop_id" value="{{ $item->shop_id }}">
                                        <div class="flex h-10 w-24 items-center justify-between rounded-lg border px-2 py-1">
                                            <button name="quantity" value="{{ $item->quantity + 1 }}" type="submit" class="text-success disabled:text-text/60">
                                                <div class="i-lucide-plus size-6"></div>
                                            </button>
                                            <div class="flex h-5 w-full grow select-none items-center justify-center bg-transparent text-center text-sm text-text outline-none">
                                                {{ $item->quantity }}
                                            </div>
                                            <button name="quantity" value="{{ $item->quantity - 1 }}" type="submit" class="text-warning disabled:text-text/60">
                                                <div class="i-lucide-minus size-6"></div>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                <div class="flex items-center gap-2 text-primary xs:col-span-2 sm:col-span-3 lg:text-lg xl:col-span-5">
                                    <span class="font-bold">{{ number_format($item->price * $item->quantity) }}</span><span class="text-sm lg:text-base">
                                        {{ getCurrency() }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </li>
                    @endforeach
                </ul>
                @endif
            </div>
        </div>
        <div class="lg:col-span-4">
            <div class="hidden rounded-lg bg-muted p-4 shadow lg:block">
                <div class="mb-2 divide-y">
                    <div class="flex items-center justify-between gap-x-2 py-6">
                        <div class="text-sm text-text/95 lg:text-base">
                            {{ __('total price') }}
                            ({{ $cart !== null ? $cart->count() : 0 }})
                        </div>
                        <div class="flex items-center gap-1 text-sm lg:text-base">
                            <div class="font-bold">{{ $cart !== null ? number_format($cart->subtotal) : 0 }}</div>
                            <div class="text-xs lg:text-sm">
                                {{ getCurrency() }}
                            </div>
                        </div>
                    </div>
                    <div class="flex items-center justify-between gap-x-2 py-6">
                        <div class="text-sm text-text/95 lg:text-base">
                            {{ __('discount') }}
                        </div>
                        <div class="flex items-center gap-1 text-sm font-medium text-warning lg:text-base">
                            <div class="font-bold">{{ $cart !== null ? number_format($cart->discount_total) : 0 }}</div>
                            <div class="text-xs lg:text-sm">تومان</div>
                        </div>
                    </div>
                    <div class="flex items-center justify-between gap-x-2 py-6">
                        <div class="text-sm text-text/95 lg:text-base">
                            {{ __('total price after discount') }}
                        </div>
                        <div class="flex items-center gap-1 text-sm text-primary lg:text-base">
                            <div class="font-bold">{{ $cart !== null ? number_format($cart->grand_total) : 0}}</div>
                            <div class="text-xs lg:text-sm">
                                {{ getCurrency() }}
                            </div>
                        </div>
                    </div>
                </div>
                <div>
                    <a href="{{ route('cart.delivery-type') }}" class="inline-flex h-11 w-full items-center justify-center gap-x-2 whitespace-nowrap rounded-md bg-primary-btn px-8 text-sm font-medium text-white ring-offset-background transition-colors hover:bg-primary/90 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50">
                        {{ __('continue')  }}
                    </a>
                </div>
            </div>
            <div class="fixed inset-x-0 bottom-0 z-20 rounded-t-xl bg-muted px-4 pb-20 pt-4 transition-all duration-300 lg:hidden" data-onscrollclass="translate-y-1/2">
                <div>
                    <a href="{{ route('cart.delivery-type') }}" class="inline-flex h-10 w-full items-center justify-center gap-x-2 whitespace-nowrap rounded-md bg-primary-btn px-4 py-2 text-sm font-medium text-white ring-offset-background transition-colors hover:bg-primary/90 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50">
                        {{ __('continue')  }}
                        |
                        {{ $cart !== null ? number_format($cart->subtotal) : 0 }}
                        <span class="text-xs"> {{ getCurrency() }} </span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
