@extends('layouts.blesser.app')


@section('content')
<div class="relative ">
    <!-- Background -->
    <div class="pointer-events-none absolute inset-0 flex items-center justify-center overflow-hidden [mask-image:radial-gradient(transparent_15%,white)]">
        <svg class="absolute left-0 top-0 h-full w-full stroke-black/20 stroke-[2] [mask-image:linear-gradient(transparent_5%,white,transparent_85%)] dark:stroke-white/20" data-n-ids="{&quot;1a4MN34vH0:0&quot;:&quot;1a4MN34vH0:0&quot;}">
            <rect width="100%" height="100%" stroke-width="0" fill="url(#grid-pattern-1a4MN34vH0:0)"></rect>
            <svg>
                <rect stroke-width="0" width="95" height="95" x="97" y="97" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="385" y="193" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="193" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="673" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="481" y="385" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1249" y="97" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="577" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1441" y="385" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1057" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="961" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1249" y="577" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
            </svg>
            <defs>
                <pattern id="grid-pattern-1a4MN34vH0:0" viewBox="0 0 64 64" width="96" height="96" patternUnits="userSpaceOnUse">
                    <path d="M64 0H0V64" fill="none"></path>
                </pattern>
            </defs>
        </svg>
    </div>
    <div class="container relative pt-10">
        <div>
            <!-- Title -->
            <div class="mb-10 flex flex-col items-center gap-4">
                <h1 class="text-lg font-medium">
                    {{ __('what topic are you looking for?') }}
                </h1>
                <p class="text-xs text-text/60 xs:text-sm">
                    {{ __('Search for your desired topic or choose from the categories below') }}
                </p>

                <div>
                    <a class="btn-primary px-8 py-2.5" href="{{  route('faq.questions.create')  }}">
                        {{ __('ثبت پرسش جدید') }}
                    </a>
                </div>
            </div>
            <!-- Search -->
            <div class="mx-auto mb-16 max-w-lg">
                <form action="{{ route('faq.questions.index') }}">

                    <label for="subject" class="sr-only">
                        {{ __('search for your topic') }}
                    </label>
                    <div class="relative">
                        <input placeholder="{{ __('Search') }}" name="search" type="text" id="subject" class=" w-full rounded-lg border bg-muted px-4 py-2.5 outline-none duration-300 placeholder:duration-300 focus:border-primary focus:placeholder:-translate-x-2">
                        <button type="submit" class="absolute inset-y-0 end-3 flex items-center pr-3 cursor-pointer">
                            <i class="i-lucide-search text-text/60"></i>
                        </button>
                    </div>
                </form>
            </div>
            <!-- Categories -->
            <div class="mb-16">
                <!-- Title -->
                <div class="mb-10 flex flex-col items-center gap-6">
                    <div class="flex size-12 items-center justify-center rounded-full bg-primary/15 p-2 text-primary">
                        <i class="i-iconamoon-category-light size-8"></i>
                    </div>
                    <p class="text-lg font-medium">
                        {{ __('categories') }}
                    </p>
                </div>
                <!-- Items -->
                <div class="grid grid-cols-2 gap-4 xs:grid-cols-3 sm:grid-cols-4 md:grid-cols-5 lg:grid-cols-6">
                    @foreach (\Artemis\Faq\Models\Category::all() as $category )
                    <a href="{{ route('faq.questions.index' , ['category' => $category->id]) }}" class="flex flex-col items-center justify-center gap-4 rounded-lg bg-muted px-4 py-6">
                        <div class="i-iconamoon-category-light size-10 text-text/60"></div>
                        <p class="text-sm text-text/80">
                            {{ $category->name }}
                        </p>
                    </a>
                    @endforeach

                </div>
            </div>
            <!-- Most Quested -->
            <x-blesser.element.most-quested :questions="$answeredQuestions" />

            <!-- Contact Us -->
            <div class="text-center text-text/80">
                {{ __('couldn\'t find what you where looking for ?') }}
                <a href="{{ route('faq.questions.create') }}" class="text-primary hover:underline border border-primary py-2.5 rounded-xl px-5">
                    {{ __('ask yourself') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
