@extends('layouts.blesser.app')

@section('content')
<div class="relative">

    <div class="pointer-events-none absolute inset-0 flex items-center justify-center overflow-hidden [mask-image:radial-gradient(transparent_15%,white)]">
        <svg class="absolute left-0 top-0 h-full w-full stroke-black/20 stroke-[2] [mask-image:linear-gradient(transparent_5%,white,transparent_85%)] dark:stroke-white/20" data-n-ids="{&quot;1a4MN34vH0:0&quot;:&quot;1a4MN34vH0:0&quot;}">
            <rect width="100%" height="100%" stroke-width="0" fill="url(#grid-pattern-1a4MN34vH0:0)"></rect>
            <svg>
                <rect stroke-width="0" width="95" height="95" x="97" y="97" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="385" y="193" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="193" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="673" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="481" y="385" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1249" y="97" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="577" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1441" y="385" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1057" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="961" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1249" y="577" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
            </svg>
            <defs>
                <pattern id="grid-pattern-1a4MN34vH0:0" viewBox="0 0 64 64" width="96" height="96" patternUnits="userSpaceOnUse">
                    <path d="M64 0H0V64" fill="none"></path>
                </pattern>
            </defs>
        </svg>
    </div>

    <div class="container relative pt-10">

        @forelse ($questions as $question )
        <div class=" rounded-lg bg-muted px-4 py-6 mb-3">
            <h1 class="text-2xl mb-2 flex justify-between align-middle">
                <p>
                    {{ $question->title }}
                    <span class="text-sm ">
                        {{ $question->category->name }}
                    </span>
                </p>
                <p>
                    ({{ $question->answers->count() }}) {{ __('answers') }}
                </p>
            </h1>
            <hr>
            <p class="p-3 whitespace-pre-line">
                {{ $question->body }}
            </p>
            <div class="flex justify-end">
                <a href="{{ route('faq.questions.show', $question->id) }}" class="text-primary">
                    {{ __('View question') }}
                </a>
            </div>
        </div>
        @empty
        <!-- Title -->
        <div class="mb-10 flex flex-col items-center gap-4">
            <h1 class="text-lg font-medium">
                {{ __('what topic are you looking for?') }}
            </h1>
            <p class="text-xs text-text/60 xs:text-sm">
                {{ __('Search for your desired topic or choose from the categories below') }}
            </p>
        </div>
        <!-- Search -->
        <div class="mx-auto mb-16 max-w-lg">
            <form action="{{ route('faq.questions.index') }}">

                <label for="subject" class="sr-only">
                    {{ __('search for your topic') }}
                </label>
                <div class="relative">
                    <input placeholder="{{ __('Search') }}" name="search" type="text" id="subject" class=" w-full rounded-lg border bg-muted px-4 py-2.5 outline-none duration-300 placeholder:duration-300 focus:border-primary focus:placeholder:-translate-x-2">
                    <button type="submit" class="absolute inset-y-0 end-3 flex items-center pr-3 cursor-pointer">
                        <i class="i-lucide-search text-text/60"></i>
                    </button>
                </div>
            </form>
        </div>

        <div class="relative rounded-lg bg-muted px-4 py-6 my-6 text-center">
            {{ __('Not Found') }}
        </div>
        @endforelse


        {{ $questions->links('pagination.blesser') }}

    </div>

</div>
@endsection
