@extends('layouts.blesser.app')

@section('content')


@if (options('home-page-slider')->isNotEmpty())
<x-blesser.ui.full-width-banner />
@endif

<!-- 4 Banner Section -->

@if (options('banner-1-out-4')->isNotEmpty())
<x-blesser.ui.banner :images="options('banner-1-out-4')->map(fn($item) => ['src' => asset('uploads/'.$item->value)])" />
@endif


<!-- Category Section -->
<x-blesser.element.category-list title="{{ __('start from here') }}" />

@module('pre-invoice')
<x-blesser.element.pre-invoice-image-text />
@endmodule

<!-- Incredible Offer Section -->
<x-blesser.element.product-offer />


<!-- 2 Banner Section -->
<x-blesser.ui.banner :images="options('banner-1-out-2')->map(fn($item) => ['src' => asset('uploads/' . $item->value)])" />


<!-- Nike Section -->
<x-blesser.element.product-slider title="{{ __('Products') }}" link="{{ route('shop') }}" />


<!-- Chosen Hot Products  Section -->
<x-blesser.element.product-grid
    title="محصولات داغ انتخابی"
    :config="['take' => 12]" />

<!-- Best sale in 10 hours Section -->
<x-blesser.element.product-slider-list :config="['take' => 15]" />


<!-- blog section -->
@if ($posts != null && $posts->isNotEmpty())
<x-blesser.element.blog-post :posts="$posts" />
@endif


@if (isset($answeredQuestions) && $answeredQuestions->isNotEmpty())
<x-blesser.element.most-quested :questions="$answeredQuestions" />
@endif

@endsection
