@extends('layouts.blesser.app')

@section('content')
<div class="container pt-10">
    <!-- Breadcrumb -->
    @if (false)
    <div class="mb-8 flex flex-wrap items-center gap-2 text-sm text-text/60">
        <a href="./index.html" class="flex items-center gap-x-1">
            {{ getSiteName() }}
            <div class="i-lucide-chevron-left size-4"></div>
        </a>
        <div>
            <a href="./blog.html" class="flex items-center gap-x-1">خواندنی
                <div class="i-lucide-chevron-left size-4"></div>
            </a>
        </div>
    </div>
    @endif

    <!-- Detail -->
    <div class="mb-16 grid grid-cols-12 grid-rows-[60px_min(500px,_1fr)] gap-4">
        <div class="col-span-12 space-y-4 md:col-span-8 lg:col-span-9">
            <div class="rounded-lg bg-muted p-3 shadow md:p-5">
                <h1 class="mb-8 font-medium md:text-xl">
                    {{ $post->title }}
                </h1>

                <div class="mb-8 flex items-center gap-2 text-sm">
                    <div class="flex items-center gap-2">
                        <div class="size-8">
                            <img src="/assets/themes/blesser/images/user.png" alt="{{ $post->author ?? $post->user->name  ?? 'admin' }}" />
                        </div>
                        <p class="font-medium text-text/90">
                            {{ $post->author ?? $post->user->name  ?? 'admin'}}
                        </p>
                    </div>
                    <div class="h-3 w-px rounded-full bg-background"></div>
                    <div class="flex items-center gap-2 text-text/60">
                        <div class="i-lucide-clock size-5"></div>
                        <div>
                            {{ verta($post->created_at)->format('Y/m/d') }}
                        </div>
                    </div>
                </div>
                <div class="mb-8">
                    @if ($post->video != null)
                    <video src="{{ asset("uploads/$post->video") }}" class="w-full rounded-xl rounded-br-[50px]" controls></video>
                    @else
                    <img src="{{ asset("uploads/$post->img") }}" alt="blog" class="w-full rounded-xl rounded-br-[50px]" />
                    @endif
                </div>
                <div class="mb-8 leading-loose text-text/90">
                    {!! $post->content !!}
                </div>
                <div class="flex justify-end">
                    <div class="text-text-/70 flex items-center justify-center gap-x-6 text-center">
                        <x-blesser.share-button />
                    </div>
                </div>
            </div>
        </div>
        <!-- Desktop Filter Section -->
        <div class="col-span-4 row-span-2 hidden md:block lg:col-span-3">
            <div class="sticky top-32 mb-4 overflow-hidden">
                <!-- hot Blogs -->
                <x-blesser.element.sidebar.new-posts />

            </div>
        </div>
    </div>


</div>
@endsection
