@extends('layouts.blesser.app')

@section('content')
<div class="container grid grid-cols-12 gap-4 pb-28 pt-10 lg:pb-10">
    <!-- Sidebar -->
    <div class="col-span-12 lg:col-span-3">
        <!-- Profile, Edit, Menu -->
        <div class="mb-4 rounded-lg bg-muted p-4 shadow">
            <!-- Desktop -->
            <div class="hidden items-center justify-between gap-2 lg:flex">
                <div class="flex items-center gap-4">
                    <div class="flex h-10 w-10 items-center justify-center rounded-full bg-primary-btn text-center text-lg font-semibold text-white">9</div>
                    <p class="line-clamp-1">{{ auth()->user()->username }}</p>
                </div>
                <a href="{{ route('user.dashboard', ['tab' => 'profile']) }}" class="rounded-full text-sm text-primary duration-300 hover:text-primary/80">
                    <div class="i-lucide-pen-line size-6"></div>
                </a>
            </div>
            <!-- Mobile -->
            <div class="flex items-center justify-center lg:hidden">
                <div class="flex flex-col items-center justify-center gap-y-4">
                    <div class="relative">
                        <div class="flex h-16 w-16 items-center justify-center rounded-full bg-primary-btn text-center text-lg font-semibold text-white">9</div>
                        <a onclick="Livewire.dispatch('showProfileTab')" class="absolute -right-3 -top-2 rounded-full border bg-muted p-1.5 text-sm text-primary">
                            <div class="i-lucide-pen-line size-5"></div>
                        </a>
                    </div>
                    <div>
                        <p class="line-clamp-1">{{ auth()->user()->name }}</p>
                        <p class="text-text/95">{{ auth()->user()->phone }}</p>
                    </div>
                    <div>
                        <button type="button" data-drawer-target="profile-drawer" data-drawer-show="profile-drawer" data-drawer-placement="bottom" aria-controls="profile-drawer" class="btn-primary flex items-center gap-1 px-4 py-2">
                            <div class="i-lucide-align-justify size-5"></div>
                            {{ __('User panel menu') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Desktop Links -->
        <div class="hidden rounded-lg shadow lg:block ">
            <x-blesser.element.user-dashboard-link class="relative space-y-2 rounded-lg bg-muted p-2" />
        </div>
    </div>

    <!-- Content -->
    <div class="col-span-12 lg:col-span-9 ">
        <div class="rounded-lg bg-muted shadow">
            <div class="p-5">
                <livewire:user.panel-tabs />

            </div>
        </div>
    </div>
</div>
@endsection
