@extends('layouts.syndron.app')


@section('content')

<div class="container-sm">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">{{ __('Loyalty Settings') }}</h3>
        </div>
        <div class="card-body">
            @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
            @endif
            <form action="{{ route('admin.loyalty.settings.update') }}" method="post">
                @csrf
                <table class="table table-bordered table-striped text-center align-middle">
                    <thead>
                        <tr>
                            <th>{{ __('#') }}</th>
                            <th>{{ __('Setting') }}</th>
                            <th>{{ __('Value') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($settings as $key => $value)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ __($key) }}</td>
                            <td>
                                <input type="text" class="form-control" name="{{ $key }}" value="{{ $value }}">
                            </td>

                        </tr>
                        @endforeach
                    </tbody>

                </table>
                <div class="d-flex justify-content-end">
                    <button class="btn btn-primary" type="submit">
                        {{ __('Update Settings') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection
