@extends('layouts.syndron.app')

@section('content')

<div class="container">


    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="card">
        <div class="card-header">
            <h1>{{ __('Create New Tier') }}</h1>
        </div>

        <div class="card-body">
            <form action="{{ route('admin.loyalty.tiers.store') }}" method="POST">
                @csrf
                <div class="mb-3">
                    <label for="name" class="form-label">{{ __('Name') }}</label>
                    <input type="text" name="name" id="name" class="form-control" value="{{ old('name') }}" required>
                </div>
                <div class="mb-3">
                    <label for="min_points" class="form-label">{{ __('Minimum Points') }}</label>
                    <input type="number" name="min_points" id="min_points" class="form-control" value="{{ old('min_points') }}" required min="0">
                </div>
                <div class="mb-3">
                    <label for="max_points" class="form-label">{{ __('Maximum Points') }}</label>
                    <input type="number" name="max_points" id="max_points" class="form-control" value="{{ old('max_points') }}" min="0">
                    <small class="form-text text-muted">{{ __('Leave blank for no upper limit.') }}</small>
                </div>
                <button type="submit" class="btn btn-primary">{{ __('Create Tier') }}</button>
                <a href="{{ route('admin.loyalty.tiers.index') }}" class="btn btn-secondary">{{ __('Cancel') }}</a>
            </form>
        </div>

    </div>
</div>

@endsection
