@extends('layouts.syndron.app')

@section('content')

<div class="container">


    @if (session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
    @endif



    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h1>{{ __('Loyalty Tiers') }}</h1>

            <div class="mb-3">
                <a href="{{ route('admin.loyalty.tiers.create') }}" class="btn btn-primary">{{ __('Create New Tier') }}</a>
            </div>

        </div>
        <div class="card-body">
            <table class="table table-bordered table-striped text-center align-middle">
                <thead>
                    <tr>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Minimum Points') }}</th>
                        <th>{{ __('Maximum Points') }}</th>
                        <th>{{ __('Actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($tiers as $tier)
                    <tr>
                        <td>{{ $tier->name }}</td>
                        <td>{{ $tier->min_points }}</td>
                        <td>{{ $tier->max_points ?? __('No limit') }}</td>
                        <td>
                            <a href="{{ route('admin.loyalty.tiers.edit', $tier) }}" class="btn btn-sm btn-warning">{{ __('Edit') }}</a>
                            <form action="{{ route('admin.loyalty.tiers.destroy', $tier) }}" method="POST" style="display:inline-block;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('<?php echo __('Are you sure?') ?>')">{{ __('Delete') }}</button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="4">{{ __('No tiers found.') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection
