@extends('layouts.becute.app')

@section('style')
<link rel="stylesheet" href="{{ url('assets/plugins/Iconsax/css/style.css') }}">

<style>
    #client-dashboard-menu {
        border-radius: 15px;
        width: 200px;
        font-size: 20px;
        padding: 15px;
    }
</style>
@endsection



@section('content')
<section class="m-5" dir="rtl">
    <div class="container d-flex justify-content-between align-items-center border-bottom pb-4">
        <div>
            <h3 class="" >
                مجموعه امتیازات:
                {{ auth()->user()->total_points ?? 0 }}
            </h3>
        </div>
        <div>
            <h3 class="" >
                کد معرفی شما:
                {{ auth()->user()->referral_code ?? 'ندارد' }}
            </h3>
        </div>
        <div id="client-dashboard-menu" class="text-center border  p3">
            <a href="{{route('client.dashboard')}}" class="d-flex justify-content-center align-content-center">
                <span class="d-inline-block ms-3">
                    برگشت
                </span>
                <img src="{{iconsax('arrow-left-3')}}" alt="">
            </a>
        </div>
    </div>

    <div class="container">
        <table class="table table-striped table-bordered text-center align-middle mt-4 ">
            <thead>
                <tr>
                    <th scope="col">ردیف</th>
                    <th scope="col">امتیاز</th>
                    <th scope="col">توضیحات</th>
                    <th scope="col">نوع</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($transactions as $transaction)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $transaction->points }}</td>
                    <td>{{ $transaction->description }}</td>
                    <td>{{ __($transaction->type) }}</td>
                </tr>
                @empty
                <tr>
                    <td class="p-3 bg-info bg-gradient" colspan="4">
                        <strong>هیچ تراکنشی یافت نشد.</strong>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</section>
@endsection
