<?php

use App\Livewire\Admin\PageItemEdit;
use Illuminate\Support\Facades\Route;
use App\Http\Actions\Admin\AdminDashboardAction;
use App\Http\Controllers\Admin\CategoryAttributeItemController;
use App\Http\Controllers\Admin\Grapesjs\AssetUploadController;
use App\Http\Controllers\Admin\Grapesjs\PageStorageController;

use App\Http\Controllers\Admin\{
    TagController,
    PageController,
    PostController,
    ShopController,
    BrandController,
    OrderController,
    CouponController,
    CommentController,
    FeatureController,
    ModuleController,
    ProductController,
    CategoryController,
    WarehouseController,
    PageBuilderController,
    PagePublishController,
    ProductBundleController,
    CategoryAttributeController,
    PreInvoiceController,
    PreInvoiceQuoteController,
    WarehouseInventoryController,
};
use Illuminate\Http\Request;

Route::get('dashboard', AdminDashboardAction::class)->name('dashboard');

Route::prefix('features')->name('features.')->group(function () {
    Route::get('/', [FeatureController::class, 'index'])->name('index');
    Route::post('/toggle/{feature}', [FeatureController::class, 'toggle'])->name('toggle');
});
Route::prefix('modules')->name('modules.')->group(function () {
    Route::get('/', [ModuleController::class, 'index'])->name('index');
});

Route::get('comments', [CommentController::class, 'index'])->name('comments.index');
Route::post('comments/{comment}/status', [CommentController::class, 'updateStatus'])->name('comments.update.status');


Route::patch('shops/{shop}/approve', [ShopController::class, 'approve'])->name('shops.approve');
Route::patch('shops/{shop}/unapprove', [ShopController::class, 'unapprove'])->name('shops.unapprove');

Route::view('file-manager', 'pages.admin.file-manager')->name('file-manager');

Route::get('page/{page}/items', PageItemEdit::class)->name('page.items.edit');

Route::view('tasks', 'pages.admin.task')->name('tasks');
Route::view('woocommerce/more/information', 'pages.admin.woocommerce-more-info')->name('woocommerce.more-info');
Route::view('suggestion/more/information', 'pages.admin.suggestion-more-info')->name('suggestion.more-info');
Route::view('suggestion/form', 'pages.admin.suggestion-form')->name('suggestion.form');



Route::get('/pages/{page}/builder', [PageBuilderController::class, 'builder'])->middleware('module:page-builder-grapes-js')->name('pages.builder');
Route::post('/pages/{page}/publish', [PagePublishController::class, 'publish'])->middleware('module:page-builder-grapes-js')->name('pages.publish');


Route::middleware(['web', 'auth', 'module:page-builder-grapes-js'])->prefix('grapesjs/assets')->group(function () {
    Route::get('/pages/{page}',  [PageStorageController::class, 'load']);  // GrapesJS load
    Route::post('/pages/{page}', [PageStorageController::class, 'store']); // GrapesJS save
    Route::post('/assets',       [AssetUploadController::class, 'store']); // Asset upload
});


Route::post('update/admin-layout', function (Request $request) {
    if ($request->has('admin_layout')) {
        $user = auth()->user();
        $user->admin_layout = $request->input('admin_layout');
        $user->save();
        return back()->sweetalert()->success('Admin layout updated successfully.');
    }
    return back()->sweetalert()->error('No admin layout provided.');
})->name('update.admin-layout');



Route::resources([
    'categories' => CategoryController::class,
    'category.attribute' => CategoryAttributeController::class,
    'attribute.item' => CategoryAttributeItemController::class,
    'product' => ProductController::class,
    'post' => PostController::class,
    'shops' => ShopController::class,
    'coupons' => CouponController::class,
    'orders' => OrderController::class,
    'product-bundle' => ProductBundleController::class,
    'page' => PageController::class,
    'brands' => BrandController::class,
    'tags' => TagController::class,
    'warehouses' => WarehouseController::class,
    'warehouse.inventory' => WarehouseInventoryController::class,
    'pre-invoice' => PreInvoiceController::class,
    'pre-invoice.quote' => PreInvoiceQuoteController::class,
]);
