<?php

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\LogoutController;
use App\Http\Controllers\Auth\RegisterController;
use Illuminate\Support\Facades\Route;

Route::middleware('guest')->group(function () {
    // Registration
    Route::view('admin/register', 'pages.admin.auth.register')->name('admin.register.form');
    Route::post('register', RegisterController::class)->name('register');

    // Login
    Route::view('admin/login', 'pages.admin.auth.login')->name('admin.login.form');
    Route::post('login', LoginController::class)->name('login');
    Route::view('login', 'pages.auth.authenticate')->name('login');

    Route::view('authenticate', 'pages.auth.authenticate')->name('authentication');
});

// Logout
Route::get('logout', LogoutController::class)->middleware('auth')->name('logout');
