<?php

use App\Models\Page;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CartController;
use App\Livewire\Blesser\ProductDetails;
use App\Http\Actions\Pages\BlogPageAction;
use App\Http\Actions\Pages\HomePageAction;
use App\Http\Actions\Pages\ShopPageAction;
use App\Http\Controllers\FilterController;
use App\Http\Actions\ChangeAppLocaleAction;
use App\Http\Actions\OrderSubmissionAction;
use App\Http\Controllers\PaymentController;
use App\Http\Actions\Pages\FaqHomePageAction;
use App\Http\Actions\OfficeEquipmentPageAction;
use App\Http\Controllers\Faq\QuestionController;
use App\Http\Actions\Pages\PostDetailsPageAction;
use App\Http\Actions\Pages\CartCheckoutPageAction;
use App\Http\Controllers\PaymentCallBackController;
use App\Http\Actions\PreInvoiceQuoteSelectionAction;
use App\Http\Actions\OfficeEquipmentProductPageAction;
use App\Http\Actions\OfficeEquipmentProductAddToCartAction;

Route::get('/', HomePageAction::class)->name('home');

Route::get('/shop', ShopPageAction::class)->name('shop');
Route::get('/shop/second-hand', ShopPageAction::class)->name('shop.second-hand');

Route::get('/product/{slug}/details', ProductDetails::class)->name('product.details');

Route::get('/blog', BlogPageAction::class)->name('blog');
Route::get('/post/{slug}/details', PostDetailsPageAction::class)->name('post.details');

Route::get('office-equipment', OfficeEquipmentPageAction::class)->name('office-equipment');
Route::get(uri: 'office-equipment-products/{group}/plan', action: OfficeEquipmentProductPageAction::class)->name('office-equipment.products');
Route::post(uri: 'office-equipment-products/{group}/add-to-cart', action: OfficeEquipmentProductAddToCartAction::class)->name('office-equipment.products.add-to-cart');

Route::view('/rules', 'pages.home')->name('rules');

Route::prefix('faq')->name('faq.')->group(function () {
    Route::get('/', FaqHomePageAction::class)->name('home');


    Route::post('/questions/{question}/answers', [QuestionController::class, 'storeAnswer'])
        ->name('questions.answers.store')
        ->middleware('auth');

    Route::post('/questions/answers/vote', [QuestionController::class, 'voteAnswer'])
        ->name('questions.answers.vote')
        ->middleware('auth');

    Route::post('/questions/{question}/answers/{answer}/best', [QuestionController::class, 'markAsBestAnswer'])
        ->name('questions.answers.best')
        ->middleware('auth');

    Route::post('/questions/{question}/answers/{answer}/comment/store', [QuestionController::class, 'storeAnswerComment'])
        ->name('questions.answers.comment.store')
        ->middleware('auth');

    Route::post('/questions/{question}/answers/{answer}/flag/store', [QuestionController::class, 'storeAnswerFlag'])
        ->name('questions.answers.flag.store')
        ->middleware('auth');


    Route::resource('questions', QuestionController::class);
});


Route::view('/pre-invoice', 'pages.pre-invoice')->middleware('module:pre-invoice')->name('pre-invoice');
Route::post('select-pre-invoice/quote', PreInvoiceQuoteSelectionAction::class)->middleware('module:pre-invoice')->name('pre-invoice.quote.selection');


Route::prefix('filter')->name('filter.')->group(function () {

    Route::get('shop/clear', [FilterController::class, 'shopClear'])->name('shop.clear');
    Route::get('shop/order-by', [FilterController::class, 'shopOrderBy'])->name('shop-order-by');
    Route::get('shop/only/available', [FilterController::class, 'onlyAvailable'])->name('shop.only.available');
    Route::get('shop/only/special-offer', [FilterController::class, 'onlySpecialOffer'])->name('shop.only.special-offer');
    Route::get('shop/only/second-hand', [FilterController::class, 'onlySecondHand'])->name('shop.only.second-hand');
    Route::get('shop/only/consumable', [FilterController::class, 'onlyConsumable'])->name('shop.only.consumable');
    Route::get('shop/only/price', [FilterController::class, 'price'])->name('shop.price');
});

Route::prefix('cart')->name('cart.')->group(function () {
    Route::get('/',         [CartController::class, 'index'])->name('index');
    Route::post('/add',     [CartController::class, 'add'])->name('add');
    Route::post('/update',  [CartController::class, 'update'])->name('update');
    Route::post('/remove',  [CartController::class, 'remove'])->name('remove');
    Route::post('/clear',   [CartController::class, 'clear'])->name('clear');

    Route::view('delivery', 'pages.cart-delivery')->name('delivery-type')->middleware('auth');

    Route::get('/checkout', CartCheckoutPageAction::class)->name('checkout')->middleware('auth');
});

Route::post('order/submission', OrderSubmissionAction::class)->name('order.submission')->middleware('auth');

Route::any('/change-lang', ChangeAppLocaleAction::class)->name('change-app-local');


// ************************* Payment User Routes *************************
Route::any('payment/create', [PaymentController::class, 'create'])->name('payment.create');

Route::post('payment', [PaymentController::class, 'store'])->name('payment.store');

Route::get('payment/{uuid}', [PaymentController::class, 'show'])->name('payment');
Route::get('payment/{uuid}/pay', [PaymentController::class, 'pay'])->name('payment.pay');
Route::post('payment/{uuid}/pay', [PaymentController::class, 'pay'])->name('payment.pay.post');

// *************************  Callbacks  *************************
Route::prefix('payment/callback/')->name('payment.callback.')->group(function () {
    Route::any('bitpay', [PaymentCallBackController::class, 'bitpay'])->name('bitpay');
});
// ************************* Payment User Routes *************************

require __DIR__ . '/authenticate.php';

Route::get('/{slug}', function ($slug) {
    $page = Page::with('items')->where('slug', $slug)->firstOrFail();
    return view('pages.page', compact('page'));
})->name('page');
