<?php

use Artemis\Faq\Http\Controllers\api\v1\TagController;
use Artemis\Faq\Http\Controllers\api\v1\VoteController;
use Artemis\Faq\Http\Controllers\api\v1\FlagController;
use Artemis\Faq\Http\Controllers\api\v1\AnswerController;
use Artemis\Faq\Http\Controllers\api\v1\CommentController;
use Artemis\Faq\Http\Controllers\api\v1\CategoryController;
use Artemis\Faq\Http\Controllers\api\v1\QuestionController;

Route::prefix('v1')->name('api.')->group(function () {
    // Comment
    Route::apiResource('comment', CommentController::class)->except(['store', 'update', 'destroy']);
    Route::apiResource('comment', CommentController::class)->only(['store', 'update', 'destroy'])
        ->middleware('auth:sanctum');
    
    // Tag
    Route::apiResource('tag', TagController::class)->except(['store', 'update', 'destroy']);
    Route::apiResource('tag', TagController::class)->only(['store', 'update', 'destroy'])
        ->middleware('auth:sanctum');
    
    // Taggable
    Route::prefix('{taggable}/{id}')->name('taggable.')->controller(TagController::class)->group(function () {
        Route::middleware('auth:sanctum')->group(function () {
            Route::post('tags', 'addTag')->name('tags.add');
            Route::delete('tags', 'removeTag')->name('tags.remove');
        });
        
        Route::get('tags', 'getTags')->name('tags.get');
    });
    
    // Category
    Route::apiResource('category', CategoryController::class)->except(['store', 'update', 'destroy']);
    Route::apiResource('category', CategoryController::class)->only(['store', 'update', 'destroy'])
        ->middleware('auth:sanctum');
    
    // Votable
    Route::prefix('{votable}/{id}')->name('votable.')->controller(VoteController::class)->group(function () {
        Route::middleware('auth:sanctum')->group(function () {
            Route::post('vote', 'addVote')->name('votes.store');
            Route::delete('vote', 'removeVote')->name('votes.destroy');
        });
        
        Route::get('vote', 'getVotes')->name('votes.get');
    });
    
    // Flag
    Route::apiResource('flag', FlagController::class)->except(['store', 'update', 'destroy']);
    Route::apiResource('flag', FlagController::class)->only(['store', 'update', 'destroy'])
        ->middleware('auth:sanctum');
    
    // Flaggable
    Route::prefix('{flaggable}/{id}')->name('flaggable.')->controller(FlagController::class)->group(function () {
        Route::post('flag', 'addFlag')->name('flags.store')
            ->middleware('auth:sanctum');
        
        Route::get('flag', 'getFlags')->name('flags.get');
    });
    
    // Question
    Route::apiResource('question', QuestionController::class)->except(['store', 'update', 'destroy']);
    Route::apiResource('question', QuestionController::class)->only(['store', 'update', 'destroy'])
        ->middleware('auth:sanctum');
    
    // Answer
    Route::apiResource('answer', AnswerController::class)->except(['store', 'update', 'destroy']);
    Route::apiResource('answer', AnswerController::class)->only(['store', 'update', 'destroy'])
        ->middleware('auth:sanctum');
});
