<?php

namespace Artemis\Faq\Http\Requests;

use Auth;
use Illuminate\Foundation\Http\FormRequest;

class AnswerStoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        return Auth::check();
    }
    
    public function rules(): array
    {
        return [
            'question_id' => ['required', 'integer', 'exists:questions,id'],
            'body' => ['required', 'string', 'min:3', 'max:1000']
        ];
    }
}
