<?php

namespace Artemis\Faq\Http\Requests;

use Auth;
use Artemis\Faq\Models\Category;
use Artemis\Faq\Rules\isUniqueSlugRule;
use Illuminate\Foundation\Http\FormRequest;

class CategoryStoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        return Auth::check();
    }
    
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'slug' => [
                'sometimes',
                'string',
                'max:255',
                'unique:categories',
                new isUniqueSlugRule(Category::class)
            ],
            'description' => ['nullable', 'sometimes', 'string', 'max:500'],
        ];
    }
}
