<?php

namespace Artemis\Faq\Http\Resources;

use Illuminate\Http\Request;
use Artemis\Faq\Models\Comment;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin Comment */
class CommentResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'creator' => $this->user_id,
            'commentable_id' => $this->commentable_id,
            'commentable_type' => class_basename($this->commentable_type),
            'body' => $this->body,
            'commented_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
