<?php

namespace Artemis\Faq\Models;

use Artemis\Faq\Traits\HasTablePrefix;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;

class Flag extends Model
{
    use HasTablePrefix;
    
    protected $fillable = [
        'user_id',
        'reason',
        'flaggable_id',
        'flaggable_type'
    ];

    public function flaggable()
    {
        return $this->morphTo();
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }

}
