<?php

namespace Artemis\Faq\Models;

use Artemis\Faq\Traits\HasTablePrefix;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Model;

class Tag extends Model
{
    use HasTablePrefix;

    protected $fillable = [
        'name',
        'slug',
    ];

    public function question(): BelongsToMany
    {
        return $this->belongsToMany(Question::class)->using(Taggable::class);
    }
}
