# 🎨 Blade & Component Structure for Loyalty Package

This document outlines the recommended folder and file structure for the Blade views and reusable components in the `artemis/laravel-loyalty` package.

---

## 🗂️ View Directory Structure

All views live inside the package at:

```
src/resources/views/
```

When loaded with:

```php
$this->loadViewsFrom(__DIR__.'/../resources/views', 'loyalty');
```

Override views from app via:

```
resources/views/vendor/loyalty/
```

---

## 📁 Admin Panel Views

```
resources/views/vendor/loyalty/admin/
├── layout.blade.php
├── dashboard.blade.php
├── tiers/
│   ├── index.blade.php
│   ├── create.blade.php
│   ├── edit.blade.php
├── rewards/
│   ├── index.blade.php
│   ├── create.blade.php
│   ├── edit.blade.php
├── referrals/
│   ├── index.blade.php
│   ├── show.blade.php
├── settings/
│   └── edit.blade.php
```

---

## 📁 Client Views

```
resources/views/vendor/loyalty/client/
├── layout.blade.php
├── points/
│   ├── index.blade.php
│   └── history.blade.php
├── rewards/
│   └── index.blade.php
```

---

## 📦 Blade Components (optional)

```
src/resources/views/components/
├── card.blade.php
├── tier-label.blade.php
├── point-badge.blade.php
```

In `LoyaltyServiceProvider.php`:

```php
Blade::componentNamespace('Artemis\Loyalty\View\Components', 'loyalty');
```

Then in any view:

```blade
<x-loyalty::card title="{{ __('Tier Overview') }}">
    ...
</x-loyalty::card>
```

---

Let me know if you'd like these files scaffolded or styled with Tailwind/UI Kit.
