<?php

namespace Artemis\Loyalty\Database\Factories;

use Artemis\Loyalty\Models\Reward;
use Illuminate\Database\Eloquent\Factories\Factory;

class RewardFactory extends Factory
{
    protected $model = Reward::class;

    public function definition(): array
    {
        return [
            'title' => $this->faker->catchPhrase,
            'description' => $this->faker->sentence,
            'points_required' => $this->faker->numberBetween(50, 500),
            'active' => true,
        ];
    }
}
