<?php


use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Route;
use Artemis\Loyalty\Http\Controllers\Client\PointController;
use Artemis\Loyalty\Http\Controllers\Client\RewardController;
use Artemis\Loyalty\Http\Controllers\Client\RedemptionController;
use Artemis\Loyalty\Http\Controllers\Client\LoyaltyDashboardController;


$clientPrefix = config('loyalty.routes.client.prefix', 'loyalty');
$clientMiddleware = config('loyalty.routes.client.middleware', ['web', 'auth']);
$clientName = config('loyalty.routes.client.name', 'loyalty.');

Route::middleware($clientMiddleware)
    ->prefix($clientPrefix)
    ->name($clientName)
    ->group(function () {
        Route::get('loyalty-dashboard', [LoyaltyDashboardController::class, 'index'])->name('dashboard');
        Route::get('rewards', [RewardController::class, 'index'])->name('rewards');
        Route::post('redeem/{reward}', [RedemptionController::class, 'redeem'])->name('redeem');
        Route::get('history', [PointController::class, 'history'])->name('history');
    });
