<?php

namespace Artemis\Loyalty\Concerns;

use Artemis\Loyalty\Models\Tier;

trait InteractsWithTiers
{
    public function currentTier(): ?Tier
    {
        $points = $this->loyalty_balance;
        return Tier::where('min_points', '<=', $points)
            ->where(function ($q) use ($points) {
                $q->whereNull('max_points')->orWhere('max_points', '>=', $points);
            })
            ->orderBy('min_points', 'desc')
            ->first();
    }

    public function upgradeTier(): void
    {
        $tier = $this->currentTier();
        if ($tier && $tier->name !== $this->tier_level) {
            $this->update(['tier_level' => $tier->name]);
        }
    }
}
