<?php

namespace Artemis\Loyalty\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class PublishControllersCommand extends Command
{
    protected $signature = 'loyalty:publish-controllers';
    protected $description = 'Publish Loyalty package controllers to your app for customization';

    public function handle()
    {
        $targetPath = config('loyalty.controller_publish_path', app_path('Http/Controllers/Loyalty'));

        $sourcePath = __DIR__ . '/../../Http/Controllers';

        if (!File::exists($sourcePath)) {
            $this->error('No controllers found in package.');
            return;
        }

        File::copyDirectory($sourcePath, $targetPath);

        $this->info("Controllers published to: {$targetPath}");
    }
}
