<?php

namespace Artemis\Loyalty\Console\Commands;

use Illuminate\Console\Command;
use Artemis\Loyalty\Database\Seeders\LoyaltySeeder;

class SeedLoyaltyCommand extends Command
{
    protected $signature = 'loyalty:seed';
    protected $description = 'Seed test data into the loyalty system';

    public function handle()
    {
        $this->call('db:seed', [
            '--class' => LoyaltySeeder::class,
        ]);

        $this->info('Loyalty data seeded successfully.');
    }
}
