<?php

namespace Artemis\Loyalty\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Artemis\Loyalty\Models\Reward;

class RewardController extends Controller
{
    public function index()
    {
        $rewards = Reward::all();
        return view('loyalty::admin.rewards.index', compact('rewards'));
    }

    public function create()
    {
        return view('loyalty::admin.rewards.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'points_cost' => 'required|integer|min:0',
            'reward_type' => 'required|string|max:255',
            'validity' => 'nullable|date',
        ]);

        Reward::create($request->only('name', 'description', 'points_cost', 'reward_type', 'validity'));

        return redirect()->route('admin.loyalty.rewards.index')
            ->with('success', __('Reward created successfully.'));
    }

    public function edit(Reward $reward)
    {
        return view('loyalty::admin.rewards.edit', compact('reward'));
    }

    public function update(Request $request, Reward $reward)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'points_cost' => 'required|integer|min:0',
            'reward_type' => 'required|string|max:255',
            'validity' => 'nullable|date',
        ]);

        $reward->update($request->only('name', 'description', 'points_cost', 'reward_type', 'validity'));

        return redirect()->route('admin.loyalty.rewards.index')
            ->with('success', __('Reward updated successfully.'));
    }

    public function destroy(Reward $reward)
    {
        $reward->delete();

        return redirect()->route('admin.loyalty.rewards.index')
            ->with('success', __('Reward deleted successfully.'));
    }
}
