<?php

namespace Artemis\Loyalty\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Artemis\Loyalty\Models\Tier;

class TierController extends Controller
{
    public function index()
    {
        $tiers = Tier::all();
        return view('loyalty::admin.tiers.index', compact('tiers'));
    }

    public function create()
    {
        return view('loyalty::admin.tiers.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'min_points' => 'required|integer|min:0',
            'max_points' => 'nullable|integer|min:0',
        ]);

        Tier::create($request->only('name', 'min_points', 'max_points'));

        return redirect()->route('admin.loyalty.tiers.index')
            ->with('success', __('Tier created successfully.'));
    }

    public function edit(Tier $tier)
    {
        return view('loyalty::admin.tiers.edit', compact('tier'));
    }

    public function update(Request $request, Tier $tier)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'min_points' => 'required|integer|min:0',
            'max_points' => 'nullable|integer|min:0',
        ]);

        $tier->update($request->only('name', 'min_points', 'max_points'));

        return redirect()->route('admin.loyalty.tiers.index')
            ->with('success', __('Tier updated successfully.'));
    }

    public function destroy(Tier $tier)
    {
        $tier->delete();

        return redirect()->route('admin.loyalty.tiers.index')
            ->with('success', __('Tier deleted successfully.'));
    }
}
