<?php

namespace Artemis\Loyalty\Http\Controllers\Client;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Artemis\Loyalty\Models\PointTransaction;
use Artemis\Loyalty\Models\Reward;
use Artemis\Loyalty\Models\Redemption;
use Illuminate\Support\Facades\Auth;

class LoyaltyDashboardController extends Controller
{

    public function index()
    {
        $transactions = PointTransaction::where('user_id', Auth::id())
            ->orderBy('created_at', 'desc')
            ->get();

        return view('loyalty::client.dashboard', compact('transactions'));
    }
}
