<?php

namespace Artemis\Loyalty\Http\Controllers\Client;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Artemis\Loyalty\Models\PointTransaction;
use Artemis\Loyalty\Models\Reward;
use Artemis\Loyalty\Models\Redemption;
use Illuminate\Support\Facades\Auth;

class RedemptionController extends Controller
{
    public function redeem(Request $request, Reward $reward)
    {
        $user = $request->user();
        $points = PointTransaction::where('user_id', $user->id)->sum('points');

        if ($points < $reward->points_cost) {
            return back()->with('error', __('Not enough points to redeem this reward.'));
        }

        Redemption::create([
            'user_id' => $user->id,
            'reward_id' => $reward->id,
            'points_spent' => $reward->points_cost,
            'redemption_date' => now(),
            'status' => 'pending',
        ]);

        return back()->with('success', __('Reward redeemed successfully and is pending approval.'));
    }
}
