<?php

namespace Artemis\Loyalty\Listeners;

use Artemis\Loyalty\Models\PointTransaction;

class LogPointsTransactionListener
{
    public function handle(\Artemis\Loyalty\Events\PointsEarned $event)
    {
        PointTransaction::create([
            'user_id' => $event->user->id,
            'points' => $event->amount,
            'description' => $event->source,
            'type' => $event->source,
            'meta' => json_encode($event->meta)
        ]);
    }
}
