<?php

namespace Artemis\Loyalty\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;

class Redemption extends Model
{
    protected $fillable = [
        'user_id',
        'reward_id',
        'points_spent',
        'redemption_date',
        'status'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function reward()
    {
        return $this->belongsTo(Reward::class);
    }
}
